import  React  from 'react';


export class Clock extends React.Component {

    constructor(props) {
      super(props);
      this.state = {date: new Date()};
    }
  
    componentDidMount() {
      this.timerID = setInterval(
        () => this.tick(),
        1000
      );
    }
  
    componentWillUnmount() {
      clearInterval(this.timerID);
    }
  
    tick() {
      this.setState({
        date: new Date()
      });
    }
  
    render() {
      return (
        <div>
          <h4>Классовый компонент (State)<br></br> ↓</h4>
          <h4>Сейчас {this.state.date.toLocaleTimeString()}.</h4>
        </div>
      );
    }
  }
